package com.metapace.printer.sample;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;

import com.metapace.thermalprinter.MetapacePrinter;

import android.app.AlertDialog;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Toast;

public class DialogManager {

	private static final String[] CODE_PAGE_ITEMS = {
		"Page 0 437 (USA, Standard Europe)",
		"Page 1 Katakana",
		"Page 2 850 (Multilingual)",
		"Page 3 860 (Portuguese)",
		"Page 4 863 (Canadian-French)",
		"Page 5 865 (Nordic)",
		"Page 16 1252 (Latin I)",
		"Page 17 866 (Cyrillic #2)",
		"Page 18 852 (Latin 2)",
		"Page 19 858 (Euro)",
		"Page 21 862 (Hebrew DOS code)",
		"Page 22 864 (Arabic)",
		"Page 23 Thai42",
		"Page 24 1253 (Greek)",
		"Page 25 1254 (Turkish)",
		"Page 26 1257 (Baltic)",
		"Page 27 Farsi",
		"Page 28 1251 (Cyrillic)",
		"Page 29 737 (Greek)",
		"Page 30 775 (Baltic)",
		"Page 31 Thai14",
		"Page 33 1255 (Hebrew New code)",
		"Page 34 Thai 11",
		"Page 35 Thai 18",
		"Page 36 855 (Cyrillic)",
		"Page 37 857 (Turkish)",
		"Page 38 928 (Greek)",
		"Page 39 Thai 16",
		"Page 40 1256 (Arabic)",
		"Page 41 1258 (Vietnam)",
		"Page 42 KHMER(Cambodia)",
		"Page 47 1250 (Czech)"
	};

	private static final String[] PRINTER_ID_ITEMS = {
		"Firmware version",
		"Manufacturer",
		"Printer model",
		"Code page"
	};
	
	static void showBluetoothDialog(Context context, final Set<BluetoothDevice> pairedDevices) {
		final String[] items = new String[pairedDevices.size()];
		int index = 0;
		for (BluetoothDevice device : pairedDevices) {
			items[index++] = device.getAddress();
		}

		new AlertDialog.Builder(context).setTitle("Paired Bluetooth printers")
				.setItems(items, new DialogInterface.OnClickListener() {
					
					public void onClick(DialogInterface dialog, int which) {
						MainActivity.metapacePrinter.connect(items[which]);
						
					}
				}).show();
	}
	
	static void showUsbDialog(final Context context, final Set<UsbDevice> usbDevices, final BroadcastReceiver usbReceiver) {
		final String[] items = new String[usbDevices.size()];
		int index = 0;
		for (UsbDevice device : usbDevices) {
			items[index++] = "Device name: " + device.getDeviceName() + ", Product ID: " + device.getProductId() + ", Device ID: " + device.getDeviceId();
		}

		new AlertDialog.Builder(context).setTitle("Connected USB printers")
				.setItems(items, new DialogInterface.OnClickListener() {
					
					public void onClick(DialogInterface dialog, int which) {
						MainActivity.metapacePrinter.connect((UsbDevice) usbDevices.toArray()[which]);
						
						// listen for new devices
						IntentFilter filter = new IntentFilter();
						filter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
						filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
						context.registerReceiver(usbReceiver, filter);
					}
				}).show();
	}

	static void showNetworkDialog(Context context, Set<String> ipAddressSet) {
		if (ipAddressSet != null) {
			 final String[] items = ipAddressSet.toArray(new String[ipAddressSet.size()]);
			
			new AlertDialog.Builder(context).setTitle("Connectable network printers")
			.setItems(items, new DialogInterface.OnClickListener() {
				
				@Override
				public void onClick(DialogInterface dialog, int which) {
					MainActivity.metapacePrinter.connect(items[which], 9100, 5000);
				}
			}).show();
		}
	}

	static void showPdf417Dialog(AlertDialog dialog, final Context context) {
		if (dialog == null) {
			LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			final View layout = inflater.inflate(R.layout.dialog_print_pdf417, null);

			dialog = new AlertDialog.Builder(context).setView(layout).setTitle("PDF417")
					.setPositiveButton("OK", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							EditText editText = (EditText) layout.findViewById(R.id.editText1);
							String data = editText.getText().toString();

							editText = (EditText) layout.findViewById(R.id.editText2);
							String string = editText.getText().toString();
							if (string.length() == 0) {
								Toast.makeText(context, "Please enter the width again.", Toast.LENGTH_SHORT).show();
								return;
							}
							int width = Integer.parseInt(string);

							editText = (EditText) layout.findViewById(R.id.editText3);
							string = editText.getText().toString();
							if (string.length() == 0) {
								Toast.makeText(context, "Please enter the height again.", Toast.LENGTH_SHORT).show();
								return;
							}
							int height = Integer.parseInt(string);
							
							int alignment = MetapacePrinter.ALIGNMENT_LEFT;
							RadioGroup radioGroup = (RadioGroup) layout.findViewById(R.id.radioGroup1);
							switch (radioGroup.getCheckedRadioButtonId()) {
							case R.id.radio1:
								alignment = MetapacePrinter.ALIGNMENT_CENTER;
								break;
								
							case R.id.radio2:
								alignment = MetapacePrinter.ALIGNMENT_RIGHT;
								break;
							}

							CheckBox checkBox = (CheckBox) layout.findViewById(R.id.checkBox1);
							if (checkBox.isChecked()) {
								MainActivity.metapacePrinter.printPdf417(data, alignment, width, height, false);
								MainActivity.metapacePrinter.formFeed(true);
							} else {
								MainActivity.metapacePrinter.printPdf417(data, alignment, width, height, true);
							}

						}
					}).setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							// TODO Auto-generated method stub

						}
					}).create();
		}
		dialog.show();
	}

	static void showQrCodeDialog(AlertDialog dialog, final Context context) {
		if (dialog == null) {
			LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			final View layout = inflater.inflate(R.layout.dialog_print_qrcode, null);

			dialog = new AlertDialog.Builder(context).setView(layout).setTitle("QR Code")
					.setPositiveButton("OK", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							EditText editText = (EditText) layout.findViewById(R.id.editText1);
							String data = editText.getText().toString();

							int model = MetapacePrinter.QR_CODE_MODEL2;
							RadioGroup radioGroup = (RadioGroup) layout.findViewById(R.id.radioGroup1);
							if (radioGroup.getCheckedRadioButtonId() == R.id.radio0) {
								model = MetapacePrinter.QR_CODE_MODEL1;
							}

							editText = (EditText) layout.findViewById(R.id.editText2);
							String string = editText.getText().toString();
							if (string.length() == 0) {
								Toast.makeText(context, "Please enter the size again.", Toast.LENGTH_SHORT).show();
								return;
							}
							int size = Integer.parseInt(string);
							
							int alignment = MetapacePrinter.ALIGNMENT_LEFT;
							radioGroup = (RadioGroup) layout.findViewById(R.id.radioGroup2);
							switch (radioGroup.getCheckedRadioButtonId()) {
							case R.id.radio3:
								alignment = MetapacePrinter.ALIGNMENT_CENTER;
								break;
								
							case R.id.radio4:
								alignment = MetapacePrinter.ALIGNMENT_RIGHT;
								break;
							}

							CheckBox checkBox = (CheckBox) layout.findViewById(R.id.checkBox1);
							if (checkBox.isChecked()) {
								MainActivity.metapacePrinter.printQrCode(data, alignment, model, size, false);
								MainActivity.metapacePrinter.formFeed(true);
							} else {
								MainActivity.metapacePrinter.printQrCode(data, alignment, model, size, true);
							}
						}
					}).setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							// TODO Auto-generated method stub

						}
					}).create();
		}
		dialog.show();
	}

	static void showCodePageDialog(AlertDialog dialog, final Context context, final Handler handler) {
		if (dialog == null) {
			dialog = new AlertDialog.Builder(context).setTitle("Code page")
					.setItems(CODE_PAGE_ITEMS, new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							switch (which) {
							case 0:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_437_USA);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page437),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 1:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_KATAKANA);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_katakana),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 2:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_850_MULTILINGUAL);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page850),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 3:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_860_PORTUGUESE);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page860),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 4:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_863_CANADIAN_FRENCH);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page863),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 5:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_865_NORDIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page865),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 6:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1252_LATIN1);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1252),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 7:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_866_CYRILLIC2);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page866),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 8:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_852_LATIN2);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page852),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 9:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_858_EURO);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page858),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 10:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_862_HEBREW_DOS_CODE);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page862),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 11:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_864_ARABIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page864),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 12:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_THAI42);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_thai42),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 13:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1253_GREEK);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1253),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 14:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1254_TURKISH);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1254),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 15:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1257_BALTIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1257),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 16:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_FARSI);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_farsi),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 17:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1251_CYRILLIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1251),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 18:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_737_GREEK);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page737),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 19:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_775_BALTIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page775),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 20:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_THAI14);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_thai14),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 21:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1255_HEBREW_NEW_CODE);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1255),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 22:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_THAI11);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_thai11),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 23:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_THAI18);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_thai18),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 24:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_855_CYRILLIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page855),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 25:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_857_TURKISH);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page857),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 26:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_928_GREEK);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page928),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 27:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_THAI16);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_thai16),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 28:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1256_ARABIC);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1256),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 29:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1258_VIETNAM);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1258),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 30:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_KHMER_CAMBODIA);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_khmer_cambodia),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
								
							case 31:
								MainActivity.metapacePrinter.setSingleByteFont(MetapacePrinter.CODE_PAGE_1250_CZECH);
								MainActivity.metapacePrinter.printText(CODE_PAGE_ITEMS[which] + "\n",
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A | MetapacePrinter.TEXT_ATTRIBUTE_EMPHASIZED,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								MainActivity.metapacePrinter.printText(context.getString(R.string.code_page_windows1250),
										MetapacePrinter.ALIGNMENT_CENTER,
										MetapacePrinter.TEXT_ATTRIBUTE_FONT_A,
										MetapacePrinter.TEXT_SIZE_HORIZONTAL1 | MetapacePrinter.TEXT_SIZE_VERTICAL1, false);
								break;
							}

						}
					}).create();
		}
		dialog.show();
	}

	static void showPrinterIdDialog(AlertDialog dialog, Context context) {
		if (dialog == null) {
			dialog = new AlertDialog.Builder(context).setTitle("Get printer ID")
					.setItems(PRINTER_ID_ITEMS, new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							switch (which) {
							case 0:
								MainActivity.metapacePrinter.getPrinterId(MetapacePrinter.PRINTER_ID_FIRMWARE_VERSION);
								break;
							case 1:
								MainActivity.metapacePrinter.getPrinterId(MetapacePrinter.PRINTER_ID_MANUFACTURER);
								break;
							case 2:
								MainActivity.metapacePrinter.getPrinterId(MetapacePrinter.PRINTER_ID_PRINTER_MODEL);
								break;
							case 3:
								MainActivity.metapacePrinter.getPrinterId(MetapacePrinter.PRINTER_ID_CODE_PAGE);
								break;
							}

						}
					}).create();

		}
		dialog.show();
	}

	static void showDirectIoDialog(AlertDialog dialog, final Context context) {
		if (dialog == null) {
			LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			final View view = inflater.inflate(R.layout.dialog_direct_io, null);

			dialog = new AlertDialog.Builder(context).setView(view).setTitle("Direct IO")
					.setPositiveButton("OK", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							EditText editText = (EditText) view.findViewById(R.id.editText1);
							String string = editText.getText().toString();
							StringTokenizer stringTokenize = new StringTokenizer(string);

							ArrayList<Byte> arrayList = new ArrayList<Byte>();
							while (stringTokenize.hasMoreTokens()) {
								try {
									byte b = Byte.parseByte(stringTokenize.nextToken(), 16);
									arrayList.add(b);
								} catch (NumberFormatException e) {
									e.printStackTrace();
									Toast.makeText(context, "Invalid command!", Toast.LENGTH_SHORT).show();
									return;
								}
							}

							CheckBox checkBox = (CheckBox) view.findViewById(R.id.checkBox1);
							boolean hasResponse = checkBox.isChecked();

							if (arrayList.size() > 0) {
								ByteBuffer buffer = ByteBuffer.allocate(arrayList.size());
								for (int i = 0; i < arrayList.size(); i++) {
									buffer.put(arrayList.get(i));
								}

								MainActivity.metapacePrinter.executeDirectIo(buffer.array(), hasResponse);
							}

						}
					}).setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

						public void onClick(DialogInterface dialog, int which) {
							// TODO Auto-generated method stub

						}
					}).create();
		}
		dialog.show();
	}
}
